import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:service/controllers/rental_contract_detail_controller.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';

class RentalContractDetailScreen extends StatelessWidget {
  const RentalContractDetailScreen({super.key});

  @override
  Widget build(BuildContext context) {
    final RentalContractDetailController controller =
        Get.put(RentalContractDetailController());

    // Retrieve the contractId argument
    final String contractId = Get.arguments as String;

    controller.fetchRentalContractDetails(contractId);

    return Scaffold(
      appBar: AppBar(
        title: Text('Rental Contract Details - $contractId'),
        actions: [
          IconButton(
            icon: const Icon(Icons.save),
            onPressed: () {
              // Save changes logic
              controller.saveChanges(contractId);
            },
          ),
        ],
      ),
      body: Obx(() {
        if (controller.rentalContractDetails.isEmpty) {
          return const Center(
            child: SpinKitFadingCube(
              color: Colors.blueAccent,
              size: 50.0,
            ),
          );
        }

        return Padding(
          padding: const EdgeInsets.all(16.0),
          child: ListView(
            children: [
              _buildHeader(context),
              const SizedBox(height: 20),
              ...controller.rentalContractDetails.entries.map((entry) {
                return _buildEditableField(
                  entry.key,
                  entry.value,
                  controller.editableFields[entry.key] ?? true,
                );
              }),
            ],
          ),
        );
      }),
    );
  }

  Widget _buildHeader(BuildContext context) {
    return Card(
      elevation: 5,
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(15.0),
      ),
      child: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Row(
          children: [
            const Icon(Icons.description, size: 50, color: Colors.blueAccent),
            const SizedBox(width: 16),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    'Contract Details',
                    style: Theme.of(context).textTheme.titleLarge,
                  ),
                  const SizedBox(height: 8),
                  const Text(
                    'Here are the details of the selected rental contract.',
                    style: TextStyle(color: Colors.black54),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildEditableField(
      String label, String? initialValue, bool isEditable) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 8.0),
      child: isEditable
          ? TextFormField(
              initialValue: initialValue,
              decoration: InputDecoration(
                labelText: label,
                border: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(12),
                ),
              ),
              onChanged: (value) {
                // Update the value in the controller
                Get.find<RentalContractDetailController>()
                    .rentalContractDetails[label] = value;
              },
            )
          : Container(
              padding: const EdgeInsets.all(16.0),
              decoration: BoxDecoration(
                color: Colors.grey[200],
                borderRadius: BorderRadius.circular(12),
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    label,
                    style: const TextStyle(
                        fontWeight: FontWeight.bold, color: Colors.black54),
                  ),
                  const SizedBox(height: 8),
                  Text(
                    initialValue ?? '',
                    style: const TextStyle(fontSize: 16, color: Colors.black87),
                  ),
                ],
              ),
            ),
    );
  }
}
