import 'package:flutter/material.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:get/get.dart';
import 'package:get_secure_storage/get_secure_storage.dart';
import 'package:service/helpers/translation.dart';
import 'package:service/screens/login_screen.dart';
import 'package:service/screens/main_menu_screen.dart';
import 'package:service/screens/rental_contract_detail_screen.dart';
import 'package:service/screens/rental_contract_list_screen.dart';
import 'package:service/screens/rental_contract_screen.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await GetSecureStorage.init();
  ThemeData(
      primarySwatch: Colors.deepPurple,
      hintColor: Colors.indigoAccent,
      cardTheme: CardTheme(
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
      ),
      textTheme: TextTheme(
        titleLarge:
            const TextStyle(color: Colors.white, fontWeight: FontWeight.bold),
        titleMedium: TextStyle(color: Colors.grey[400]),
      ));
  runApp(const AvertecService());
}

class AvertecService extends StatelessWidget {
  const AvertecService({super.key});

  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      title: 'Avertec',
      debugShowCheckedModeBanner: false,
      initialRoute: '/',
      getPages: [
        GetPage(name: '/', page: () => const LoginScreen()),
        GetPage(name: '/mainmenu', page: () => const MainMenuScreen()),
        GetPage(
            name: '/rentalContract', page: () => const RentalContractScreen()),
        GetPage(name: '/contractList', page: () => const ContractListScreen()),
        GetPage(
            name: '/rentalContractDetail',
            page: () => const RentalContractDetailScreen()),

        // GetPage(name: '/order', page: () => const OrderScreen()),
        // GetPage(name: '/receipt', page: () => const ReceiptScreen()),
        // GetPage(name: '/parlay', page: () => const ParlayScreen()),
        // GetPage(name: '/result', page: () => const ResultsScreen()),
        // GetPage(name: '/report', page: () => const ReportScreen()),
        // GetPage(
        //     name: '/bluetoothprinter',
        //     page: () => const BluetoothPrinterScreen()),
      ],
      locale: const Locale('en', 'US'),
      fallbackLocale: const Locale('en', 'US'),
      translations: AvertecTranslation(),
      supportedLocales: const [
        Locale('en', 'US'),
        Locale('zh', 'CN'),
      ],
      localizationsDelegates: const [
        GlobalMaterialLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate
      ],
    );
  }
}
