import 'dart:convert';
import 'package:encrypt/encrypt.dart';
import 'package:crypto/crypto.dart';

class DataEncryptor {
  static final DataEncryptor _instance = DataEncryptor._internal();
  factory DataEncryptor() => _instance;

  DataEncryptor._internal();

  static final _key = Key.fromUtf8("i05IWM17iRd6LMse");
  static final _encrypter = Encrypter(AES(_key, mode: AESMode.cbc));

  String encryptData(String data) {
    final iv = IV.fromSecureRandom(16);
    final encrypted = _encrypter.encrypt(data, iv: iv);

    final hmacSha256 = Hmac(sha256, _key.bytes);
    final hmac = hmacSha256.convert(encrypted.bytes);

    final result = base64Encode(iv.bytes + hmac.bytes + encrypted.bytes);
    return result;
  }
}
