import 'package:get/get.dart';
import 'package:service/helpers/helper.dart';
import 'package:service/helpers/snackbar.dart';

class ContractListController extends GetxController {
  var contracts = <Map<String, dynamic>>[].obs;

  void fetchContracts(String customerName) async {
    try {
      final res = await Helper().getAllRentalByCustomer();
      if (res['code'] == 1 && res['message'] == 'Success') {
        List<dynamic> contractList = res['contract'];
        contracts.value = contractList.map((contract) {
          return {
            'id': contract['id'],
            'contractId': contract['contractId'],
            'startDate': contract['startDate'],
            'endDate': contract['endDate'],
          };
        }).toList();
      } else {
        CustomSnackbar().showErrorDialog(res['code']);
      }
    } catch (e) {
      // Handle exceptions
      CustomSnackbar().showErrorDialog(e.toString());
    }
  }
}
