import 'package:get/get.dart';
import 'package:service/helpers/helper.dart';
import 'package:service/helpers/snackbar.dart';

class RentalContractDetailController extends GetxController {
  var rentalContractDetails = <String, String>{}.obs;
  var editableFields = <String, bool>{}.obs;

  // Mapping of display keys to backend keys
  final Map<String, String> keyMapping = {
    'Customer Name': 'customer',
    'Customer Address': 'c_10012',
    'Customer Office Number': 'c_10023',
    'PIC 1 Name': 'c_10034',
    'PIC 1 Number': 'c_10045',
    'PIC 2 Name': 'c_10056',
    'PIC 2 Number': 'c_10067',
    'Contract ID': 'r_20013',
    'Contract Date': 'r_20024',
    'Contract Period': 'r_20035',
    'Contract Reminder': 'r_20046',
    'Rental ID': 'r_20057',
    'Model': 'r_20068',
    'Chassis Number': 'r_20079',
    'Engine Number': 'r_20080',
    'Mast': 'r_20091',
    'Attachment': 'r_20102',
    'Fork': 'r_20113',
    'Charger Serial Number': 'r_20124',
    'Additional Info': 'r_20135',
    'Remark': 'r_20146',
    'Deposit': 'r_20157',
    'Monthly Rental': 'r_20168',
    'Monthly Invoice Date': 'r_20179',
    'Delivery Date': 'r_20180',
    'DO Number': 'r_20191',
    'Rental Start Date': 'r_20202',
    'Return Date': 'r_20213',
  };

  void fetchRentalContractDetails(String contractId) async {
    try {
      final res = await Helper().getRentalDetail(contractId);
      if (res['code'] == 1 && res['message'] == 'Success') {
        final contractDetail = res['contractDetail'][0];
        rentalContractDetails.value = {
          'Customer Name': contractDetail['customerName'],
          'Customer Address': contractDetail['customerAddress'],
          'Customer Office Number': contractDetail['customerOfficeNumber'],
          'PIC 1 Name': contractDetail['customerPIC1'],
          'PIC 1 Number': contractDetail['customerPIC1Number'],
          'PIC 2 Name': contractDetail['customerPIC2'],
          'PIC 2 Number': contractDetail['customerPIC2Number'],
          'Contract ID': contractDetail['contractNo'],
          'Contract Date': contractDetail['contractDate'],
          'Contract Period': contractDetail['contractPeriod'],
          'Contract Reminder': contractDetail['contractReminder'],
          'Rental ID': contractDetail['contractRentalId'],
          'Model': contractDetail['contractModel'],
          'Chassis Number': contractDetail['contractChasisNumber'],
          'Engine Number': contractDetail['contractEngineNumber'],
          'Mast': contractDetail['contractMast'],
          'Attachment': contractDetail['contractAttachment'],
          'Fork': contractDetail['contractFork'],
          'Charger Serial Number':
              contractDetail['contractChargerSerialNumber'],
          'Additional Info': contractDetail['contractAdditional'],
          'Remark': contractDetail['contractRemark'],
          'Deposit': contractDetail['contractDeposit'],
          'Monthly Rental': contractDetail['contractMonthlyRental'],
          'Monthly Invoice Date': contractDetail['contractMonthlyInvoiceDate'],
          'Delivery Date': contractDetail['contractDeliveryDate'],
          'DO Number': contractDetail['contractDONumber'],
          'Rental Start Date': contractDetail['contractRentalStartDate'],
          'Return Date': contractDetail['contractReturnDate'],
        };

        editableFields.value = {
          'Customer Name': false,
          'Customer Address': false,
          'Customer Office Number': false,
          'PIC 1 Name': false,
          'PIC 1 Number': false,
          'PIC 2 Name': false,
          'PIC 2 Number': false,
          'Contract ID': false,
          'Contract Date': false,
          'Contract Period': true,
          'Contract Reminder': true,
          'Rental ID': false,
          'Model': true,
          'Chassis Number': true,
          'Engine Number': true,
          'Mast': true,
          'Attachment': true,
          'Fork': true,
          'Charger Serial Number': true,
          'Additional Info': true,
          'Remark': true,
          'Deposit': false,
          'Monthly Rental': true,
          'Monthly Invoice Date': true,
          'Delivery Date': true,
          'DO Number': false,
          'Rental Start Date': false,
          'Return Date': true,
        };
      } else {
        CustomSnackbar().showErrorDialog(res['code']);
      }
    } catch (e) {
      CustomSnackbar().showErrorDialog(e.toString());
    }
  }

  void saveChanges(contractId) async {
    try {
      // Map to hold the backend key-value pairs
      Map<String, String> backendData = {};

      // Convert the display keys to backend keys using the keyMapping
      rentalContractDetails.forEach((key, value) {
        if (keyMapping.containsKey(key)) {
          backendData[keyMapping[key]!] = value;
        }
      });
      print(backendData);
      // final res = await Helper().updateRentalDetail(backendData);
      // if (res['code'] == 1 && res['message'] == 'Success') {
      //   CustomSnackbar().showSuccessDialog('Changes saved successfully');
      // } else {
      //   CustomSnackbar().showErrorDialog(res['message']);
      // }
    } catch (e) {
      CustomSnackbar().showErrorDialog(e.toString());
    }
  }
}
