import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:service/helpers/helper.dart';
import 'package:service/helpers/snackbar.dart';

class RentalContractController extends GetxController {
  var rentalContracts = <Map<String, dynamic>>[].obs;

  @override
  void onInit() {
    super.onInit();
    fetchRentalContracts();
  }

  void fetchRentalContracts() async {
    try {
      Map<String, dynamic> res = {'code': 404, 'message': 'Fail'};
      res = await Helper().getAllRentalList();
      if (res['code'] == 1 && res['message'] == 'Success') {
        // Parse the response and update rentalContracts
        List<dynamic> customers = res['customers'];
        rentalContracts.value = customers.map((customer) {
          return {
            'customerName': customer['name'],
            'contractCount': customer['count'],
          };
        }).toList();
      } else {
        _showErrorSnackbar(res['code']);
      }
    } catch (e) {
      _showErrorSnackbar(e.toString());
    }
  }

  void _showErrorSnackbar(String message) {
    WidgetsBinding.instance.addPostFrameCallback((_) {
      CustomSnackbar().showErrorDialog(message);
    });
  }
}
