import 'package:get/get.dart';
import 'package:service/helpers/helper.dart';
import 'package:service/helpers/snackbar.dart';

class MainMenuController extends GetxController {
  var totalRental = 0.obs;
  var newRental = 0.obs;
  var rentalDueAlready = 0.obs;
  var rentalDueThisWeek = 0.obs;
  var rentalEnd = 0.obs;
  var rentalEndThisWeek = 0.obs;

  var totalPms = 0.obs;
  var pmsDue = 0.obs;
  var pmsLate = 0.obs;

  @override
  void onInit() {
    super.onInit();
    fetchRentalRecords();
  }

  void fetchRentalRecords() async {
    try {
      var response = await Helper().getTotalRentalRecord();
      if (response['code'] == 1 && response['message'] == 'Success') {
        totalRental.value = int.parse(response['totalRental']);
        newRental.value = response['newRental'];
        rentalDueAlready.value = response['rentalHaventCollect'];
        rentalDueThisWeek.value = response['rentalToCollect'];
        rentalEnd.value = response['contractHasEnd'];
        rentalEndThisWeek.value = response['contractGoingEnd'];

        totalPms.value = int.parse(response['totalPms']);
        pmsDue.value = response['pmsDue'];
        pmsLate.value = response['pmsLate'];
      } else {
        // Handle error scenario
        CustomSnackbar().showErrorDialog(response['code']);
      }
    } catch (e) {
      // Handle exceptions
      CustomSnackbar().showErrorDialog(e.toString());
    }
  }

  // Similarly, you can add a method to fetch maintenance records
  void fetchMaintenanceRecords() async {
    // Implement similar logic for fetching maintenance records
  }
}
